<?php
$con = mysqli_connect("127.0.0.1","root","","ldp_db");
if (mysqli_connect_errno()) {
    echo "Failed to connect to MySQL: " . mysqli_connect_error();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>LDP</title>
  <link rel="icon" type="image/png" href="/ldp/public/assets/img/logo.png">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Bootstrap / FontAwesome / AdminLTE -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.2.0/css/adminlte.min.css">
  
  <!-- Add in <head> -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css">

<!-- Add before </body> -->
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>

  <style>
    .data-actions a { margin-right: .35rem; }
    .form-required:after { content:" *"; color:#dc3545; }
  </style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#"><i class="fas fa-bars"></i></a>
      </li>
    </ul>
    <ul class="navbar-nav ml-auto">
      <li class="nav-item d-none d-sm-inline-block mr-3">
        <span class="text-muted">Signed in as <strong><?= htmlspecialchars($user['name'] ?? 'Guest') ?></strong> (<?= htmlspecialchars($user['role'] ?? '-') ?>)</span>
      </li>
      <li class="nav-item"><a href="/ldp/public/logout.php" class="btn btn-outline-danger btn-sm">Logout</a></li>
    </ul>
  </nav>

  <!-- Sidebar -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <a href="/ldp/public/dashboard.php" class="brand-link">
      <img src="/ldp/public/assets/img/logo.png" alt="Logo" class="brand-image img-circle elevation-3" style="opacity:.9">
      <span class="brand-text font-weight-light">DEBESMSCAT LDP</span>
    </a>
    <div class="sidebar">
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview">
          <li class="nav-item">
            <a href="/ldp/public/dashboard.php" class="nav-link <?= $active==='dashboard'?'active':'' ?>">
              <i class="nav-icon fas fa-tachometer-alt"></i><p>Dashboard</p>
            </a>
          </li>

          <li class="nav-item has-treeview <?= $active==='personnel'?'menu-open':'' ?>">
            <a href="#" class="nav-link <?= $active==='personnel'?'active':'' ?>">
                <i class="nav-icon fas fa-id-badge"></i>
                <p>
                    Personnel Records
                    <i class="right fas fa-angle-left"></i>
                </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="/ldp/public/personnel/create.php" class="nav-link <?= $subactive==='add'?'active':'' ?>">
                    <i class="far fa-circle nav-icon"></i>
                    <p>Add Employee</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="/ldp/public/personnel/index.php" class="nav-link <?= $subactive==='list'?'active':'' ?>">
                    <i class="far fa-circle nav-icon"></i>
                    <p>Employee List</p>
                </a>
              </li>
            </ul>
          </li>

          <li class="nav-item">
            <a href="/ldp/public/trainings/index.php" class="nav-link <?= $active==='trainings'?'active':'' ?>">
              <i class="nav-icon fas fa-chalkboard-teacher"></i><p>Add Trainings</p>
            </a>
          </li>

          <li class="nav-item">
            <a href="/ldp/public/reportstrainings/index.php" class="nav-link <?= $active==='trainings'?'active':'' ?>">
              <i class="nav-icon fas fa-chalkboard-teacher"></i><p>Training Reports</p>
            </a>
          </li>

          <li class="nav-item">
            <a href="/ldp/public/reports/personnel.php" class="nav-link <?= $active==='reports'?'active':'' ?>">
              <i class="nav-icon fas fa-chart-bar"></i><p>Personnel Reports</p>
            </a>
          </li>
        </ul>
      </nav>
    </div>
  </aside>

  <!-- Content Wrapper -->
  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <h1 class="mb-2"></h1>
      </div>

      <div class="card-body p-0">
        <div class="table-responsive">
          <table id="table1" class="table table-striped mb-0">
            <thead>
              <tr>
                <th style="width:70px;">ID</th>
                <th>Trainee Name</th>
                <th style="width:220px;">Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php
              $query12 = mysqli_query($con, "SELECT DISTINCT(traineename) FROM training") or die(mysqli_error($con));
              $modals = []; // store modal HTML to render later
              while($row12 = mysqli_fetch_array($query12)) {
                  $traineeid = $row12['traineename'];
                  $query10 = mysqli_query($con, "SELECT * FROM personnel WHERE id='$traineeid'") or die(mysqli_error($con));
                  $row10 = mysqli_fetch_array($query10);
                  ?>
                  <tr>
                    <td><?= $row10['id']; ?></td>
                    <td><?= $row10['name']; ?></td>
                    <td>
                      <button class="btn btn-sm btn-info" data-toggle="modal" data-target="#trainingModal<?= $row10['id']; ?>">
                        <i class="fas fa-eye"></i> View Trainings
                      </button>
                    </td>
                  </tr>
                  <?php
                  // Prepare modal content to render later
                  ob_start();
                  ?>
                  <div class="modal fade" id="trainingModal<?= $row10['id']; ?>" tabindex="-1" role="dialog">
                    <div class="modal-dialog modal-xl" role="document">
                      <div class="modal-content">
                        <div class="modal-header">
                          <h5 class="modal-title">Trainings of <?= htmlspecialchars($row10['name']); ?></h5>
                          <button type="button" class="close" data-dismiss="modal">&times;</button>
                        </div>
                        <div class="modal-body">
						 <div class="mb-2">
         
        </div>
                          <div class="table-responsive">
                            <table id="trainingTable<?= $row10['id']; ?>" class="table table-bordered table-striped">
                              <thead class="thead-dark">
                                <tr>
                                  <th>ID</th>
                                  <th>Title</th>
                                  <th>Description</th>
                                  <th>Date From</th>
                                  <th>Date To</th>
                                  <th>Schedule</th>
                                 
                                  <th>Created At</th>
                                  <th>Updated At</th>
                                  <th>Level of Training</th>
                                  <th>L&D</th>
                                </tr>
                              </thead>
                              <tbody>
                                <?php
                                $tid = $row10['id'];
                                $qTrainings = mysqli_query($con, "SELECT * FROM training WHERE traineename = '$tid'") or die(mysqli_error($con));
                                if(mysqli_num_rows($qTrainings) > 0){
                                  while($tr = mysqli_fetch_assoc($qTrainings)){
                                    ?>
                                    <tr>
                                      <td><?= $tr['id']; ?></td>
                                      <td><?= $tr['title']; ?></td>
                                      <td><?= $tr['description']; ?></td>
                                      <td><?= $tr['date_from']; ?></td>
                                      <td><?= $tr['date_to']; ?></td>
                                      <td><?= $tr['schedule']; ?></td>
                                      
                                      <td><?= $tr['created_at']; ?></td>
                                      <td><?= $tr['updated_at']; ?></td>
                                      <td><?= $tr['leveloftraining']; ?></td>
                                      <td><?= $tr['lnd']; ?></td>
                                    </tr>
                                    <?php
                                  }
                                } else {
                                  echo '<tr><td colspan="11" class="text-center text-muted">No training records found</td></tr>';
                                }
                                ?>
                              </tbody>
                            </table>
							
							<button class="btn btn-sm btn-primary" onclick="printTable('trainingTable<?= $row10['id']; ?>')">
    <i class="fas fa-print"></i> Print
</button>
<button class="btn btn-sm btn-success" onclick="downloadPDF('trainingTable<?= $row10['id']; ?>','Trainings_<?= $row10['name']; ?>')">
    <i class="fas fa-file-pdf"></i> PDF
</button>
                          </div>
                        </div>
                        <div class="modal-footer">
                          <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <?php
                  $modals[] = ob_get_clean();
              }
              ?>
            </tbody>
          </table>
        </div>
      </div>

      <!-- Render modals after table -->
      <?php foreach($modals as $modal) echo $modal; ?>

    </section>
  </div>

  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.2.0/js/adminlte.min.js"></script>

<!-- DataTables JS (after jQuery) -->
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>

<!-- Initialize DataTables -->
<script>
$(document).ready(function() {
    $('#table1').DataTable({
        "paging": true,
        "searching": true,
        "info": false
    });
});
</script>

<script>



function printTable(tableId) {
    // Find the table inside the modal
    var table = document.getElementById(tableId);
    if (!table) {
        alert("Table not found!");
        return;
    }

    // Clone the table to avoid hidden modal issues
    var clone = table.cloneNode(true);

    // Create a new window for printing
    var newWin = window.open('', '_blank');
    newWin.document.write('<html><head><title>Print</title>');
    newWin.document.write('<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">');
    newWin.document.write('<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.2.0/css/adminlte.min.css">');
    newWin.document.write('</head><body>');
    
    // Add the modal title
    var modalTitle = table.closest('.modal').querySelector('.modal-title').innerText;
    newWin.document.write('<h3 class="text-center mb-4">' + modalTitle + '</h3>');

    // Append cloned table
    newWin.document.body.appendChild(clone);

    newWin.document.write('</body></html>');
    newWin.document.close();

    // Ensure styles are applied before printing
    newWin.onload = function () {
        newWin.focus();
        newWin.print();
        newWin.close();
    };
}

function downloadPDF(tableId, filename) {
    const { jsPDF } = window.jspdf;
    var doc = new jsPDF();
    var title = document.querySelector('#' + tableId).closest('.modal').querySelector('.modal-title').innerText;
    doc.text(title, 14, 15); // Add modal title
    doc.autoTable({
        html: '#' + tableId,
        startY: 20,
        headStyles: { fillColor: [52, 58, 64] }, // dark header
        alternateRowStyles: { fillColor: [245, 245, 245] }, // light gray rows
        styles: { fontSize: 10 }
    });
    doc.save(filename + '.pdf');
}

</script>

</body>
</html>
